package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.validators;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.MicrodataUtils;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.classificator.ItemTypeClassificator;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.ComplexMicrodata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.Microdata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.MicrodataValidatorException;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 11/8/11
 * Time: 6:23 AM
 */
public class BusinessReviewCheckingMicrodataValidatorWrapper implements MicrodataValidator {

    private final List<MicrodataValidator> microdataValidators;

    public BusinessReviewCheckingMicrodataValidatorWrapper(final List<MicrodataValidator> microdataValidators) {
        this.microdataValidators = microdataValidators;
    }

    @Override
    public List<MicrodataValidatorException> validate(final Microdata microdata) {
        if (microdata instanceof ComplexMicrodata) {
            final Microdata itemReviewed = ((ComplexMicrodata) microdata).getFirst("itemReviewed");
            if (itemReviewed != null && itemReviewed instanceof ComplexMicrodata) {
                final String baseItemtype = ((ComplexMicrodata) itemReviewed).getType();
                final String type = MicrodataUtils.extractType(baseItemtype);
                final String rootType = ItemTypeClassificator.getRoot(type);
                if ("Place".equalsIgnoreCase(rootType) || "Organization".equalsIgnoreCase(rootType)) {
                    final List<MicrodataValidatorException> exceptions = new LinkedList<MicrodataValidatorException>();
                    for (final MicrodataValidator validator : microdataValidators) {
                        exceptions.addAll(validator.validate(microdata));
                    }
                    return exceptions;
                }
            }
        }
        return Collections.emptyList();
    }
}
