package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.validators;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.ComplexMicrodata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.Microdata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.MicrodataValidatorException;

import java.util.LinkedList;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 6/29/12
 * Time: 8:26 PM
 */
public class DFSVisitorMicrodataValidatorWrapper implements MicrodataValidator {

    private MicrodataValidator validator;

    public void setValidator(final MicrodataValidator validator) {
        this.validator = validator;
    }

    @Override
    public List<MicrodataValidatorException> validate(final Microdata microdata) {
        final LinkedList<MicrodataValidatorException> exceptions = new LinkedList<MicrodataValidatorException>();
        exceptions.addAll(validator.validate(microdata));
        if (microdata instanceof ComplexMicrodata) {
            for (final String prop : ((ComplexMicrodata) microdata).getPropList()) {
                for (final Microdata data : ((ComplexMicrodata) microdata).getPropAsList(prop))
                    exceptions.addAll(validate(data));
            }
        }
        return exceptions;
    }
}
