package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.validators;

import ru.yandex.common.util.collections.Cf;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.Microdata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.MicrodataValidatorException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.OrphansMicrodataValidatorException;

import java.util.Collections;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 11/8/11
 * Time: 5:53 AM
 */
public class OrphansMicrodataValidator implements MicrodataValidator {

    @Override
    public List<MicrodataValidatorException> validate(final Microdata microdata) {
        if ((microdata.flags & Microdata.ORPHANS) != 0) {
            return Cf.<MicrodataValidatorException>list(new OrphansMicrodataValidatorException(true, "", microdata));
        }
        return Collections.emptyList();
    }
}
