package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.validators;

import ru.yandex.common.util.collections.Cf;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.Microdata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.MicrodataValidatorException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.PrefixMicrodataExceptionWrapper;

import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 05.11.14
 * Time: 14:52
 */
public class PrefixWrapperMicrodataValidator implements MicrodataValidator {

    final MicrodataValidator validator;
    final String prefix;

    public PrefixWrapperMicrodataValidator(MicrodataValidator validator, final String prefix) {
        this.validator = validator;
        this.prefix = prefix;
    }

    @Override
    public List<MicrodataValidatorException> validate(final Microdata microdata) {
        return Cf.<MicrodataValidatorException>list(
                PrefixMicrodataExceptionWrapper.wrapAll(validator.validate(microdata), prefix));
    }
}
