package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.validators;

import ru.yandex.common.util.collections.Cf;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.MicrodataUtils;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.ComplexMicrodata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.Microdata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.*;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 11/8/11
 * Time: 6:23 AM
 */
public class ProductWithOfferCheckingMicrodataValidatorWrapper implements MicrodataValidator {

    private final List<MicrodataValidator> microdataValidators;

    public ProductWithOfferCheckingMicrodataValidatorWrapper(final List<MicrodataValidator> microdataValidators) {
        this.microdataValidators = microdataValidators;
    }

    @Override
    public List<MicrodataValidatorException> validate(final Microdata microdata) {
        if (microdata instanceof ComplexMicrodata) {
            final Microdata itemReviewed = ((ComplexMicrodata) microdata).getFirst("offers");
            if (itemReviewed != null && itemReviewed instanceof ComplexMicrodata) {
                final String baseItemtype = ((ComplexMicrodata) itemReviewed).getType();
                final String type = MicrodataUtils.extractType(baseItemtype);
                if ("Offer".equalsIgnoreCase(type)||"AggregateOffer".equalsIgnoreCase(type)) {
                    final List<MicrodataValidatorException> exceptions = new ArrayList<MicrodataValidatorException>();
                    for (final MicrodataValidator validator : microdataValidators) {
                        exceptions.addAll(PrefixMicrodataExceptionWrapper.wrapAll(validator.validate(microdata),
                                "product_snippet_condition"));
                    }
                    return exceptions;
                }
            } else {
                return Cf.<MicrodataValidatorException>list(
                        new PrefixMicrodataExceptionWrapper(
                                new NoFieldMicrodataValidatorException(true, "offers", microdata),
                                "product_snippet_condition"
                        )
                );
            }
        }
        return Collections.emptyList();
    }
}
