package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.validators;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.MicrodataUtils;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.classificator.ItemTypeClassificator;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.ComplexMicrodata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.Microdata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.MicrodataValidatorException;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 11/8/11
 * Time: 6:23 AM
 */
public class SchemaOrgTypeCheckingMicrodataValidatorWrapper implements MicrodataValidator {

    private final List<String> rootTypes;
    private final List<MicrodataValidator> microdataValidators;

    public SchemaOrgTypeCheckingMicrodataValidatorWrapper(final List<String> rootTypes, final List<MicrodataValidator> microdataValidators)
    {
        this.rootTypes = rootTypes;
        this.microdataValidators = microdataValidators;
    }

    public SchemaOrgTypeCheckingMicrodataValidatorWrapper(final String rootType, final List<MicrodataValidator> microdataValidators) {
        this.rootTypes = Collections.singletonList(rootType);
        this.microdataValidators = microdataValidators;
    }

    @Override
    public List<MicrodataValidatorException> validate(final Microdata microdata) {
        if (microdata instanceof ComplexMicrodata) {
            final String baseItemtype = ((ComplexMicrodata) microdata).getType();
            if (MicrodataUtils.isSchemaOrgTypeHref(baseItemtype)) {

                final String type = MicrodataUtils.extractType(baseItemtype);
                final String rootType = ItemTypeClassificator.getRoot(type);
                if (containsIgnoreCase(rootTypes, rootType)) {
                    final List<MicrodataValidatorException> exceptions = new LinkedList<MicrodataValidatorException>();
                    for (final MicrodataValidator validator : microdataValidators) {
                        exceptions.addAll(validator.validate(microdata));
                    }
                    return exceptions;
                } else {
                    return Collections.emptyList();
                }
            }
        }
        return Collections.emptyList();

    }

    private boolean containsIgnoreCase(List<String> rootTypes, String testRootType) {
        for (String rootType : rootTypes) {
            if (rootType.equalsIgnoreCase(testRootType)) {
                return true;
            }
        }
        return false;
    }
}
