package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.validators;

import ru.yandex.common.util.Su;
import ru.yandex.common.util.collections.Cf;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.MicrodataUtils;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.ComplexMicrodata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.Microdata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.MicrodataValidatorException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.UnknownMicrodataValidatorException;

import java.util.Collections;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 11/8/11
 * Time: 5:53 AM
 */
public class UnknownTypeMicrodataValidator implements MicrodataValidator {

    private final String[] prefixes;

    public UnknownTypeMicrodataValidator(final String[] prefixes) {
        this.prefixes = prefixes.clone();
    }


    @Override
    public List<MicrodataValidatorException> validate(final Microdata microdata) {
        if (microdata instanceof ComplexMicrodata) {
            final String itemType = ((ComplexMicrodata) microdata).getType();
            if (!Su.isEmpty(itemType)) {
                String httpType = MicrodataUtils.addPrefixIfEmpty(itemType);
                boolean found = false;
                for (final String prefix : prefixes) {
                    if (httpType.startsWith(prefix)) {
                        found = true;
                        break;
                    }
                }
                if (found) {
                    return Collections.emptyList();
                }
                return Cf.<MicrodataValidatorException>list(
                        new UnknownMicrodataValidatorException(false, itemType, microdata));
            }
        }
        return Collections.emptyList();
    }
}
