package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.validators;

import ru.yandex.common.util.collections.Cf;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.MicrodataUtils;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.classificator.ItemTypeClassificator;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.ComplexMicrodata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.Microdata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.MicrodataValidatorException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.NoFieldMicrodataValidatorException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.YandexReviewWrongItemlMicrodataValidatorException;

import java.util.Collections;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 12/6/11
 * Time: 1:03 AM
 */
public class UnsupportedItemReviewedMicrodataValidator implements MicrodataValidator {

    @Override
    public List<MicrodataValidatorException> validate(final Microdata microdata) {
        if (microdata instanceof ComplexMicrodata) {
            final Microdata itemReviewed = ((ComplexMicrodata) microdata).getFirst("itemReviewed");
            if (itemReviewed != null) {
                if (itemReviewed instanceof ComplexMicrodata) {
                    final String type = ((ComplexMicrodata) itemReviewed).getType();
                    if (type != null) {
                        final String rootType = ItemTypeClassificator.getRoot(MicrodataUtils.extractType(type));
                        if ("Place".equalsIgnoreCase(rootType) || "Organization".equalsIgnoreCase(rootType) ||
                                "Auto".equalsIgnoreCase(rootType) || "Car".equalsIgnoreCase(rootType)) {
                            return Collections.emptyList();
                        }
                    }
                }
                return Cf.<MicrodataValidatorException>list(
                        new YandexReviewWrongItemlMicrodataValidatorException(false, "", microdata));
            } else {
                return Cf.<MicrodataValidatorException>list(
                        new NoFieldMicrodataValidatorException(false, "itemReviewed", microdata));
            }
        }
        return Collections.emptyList();
    }
}
