package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.validators;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.ComplexMicrodata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.Microdata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.MicrodataValidatorException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.YandexOrgTelMicrodataValidatorException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data.Organization;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.struct_data.StructuredDataTransformers;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 11/8/11
 * Time: 5:53 AM
 */
public class YaOrgTelMicrodataValidator implements MicrodataValidator {

    private final static HashSet<Long> catList = new HashSet<Long>();

    static {
        long[] cats = {184105402L, 184106298L, 184105274L, 184105244L, 184105406L, 184108155L, 184107315L,
                184107311L, 184105272L, 184105270L, 184108357L};
        for (long cat : cats) {
            catList.add(cat);
        }
    }

    private final boolean isCritical;

    public YaOrgTelMicrodataValidator(final boolean isCritical) {
        this.isCritical = isCritical;
    }

    @Override
    public List<MicrodataValidatorException> validate(final Microdata microdata) {
        final List<MicrodataValidatorException> exceptions = new LinkedList<MicrodataValidatorException>();
        if (microdata instanceof ComplexMicrodata) {
            Organization org = StructuredDataTransformers.fromSchemaOrgOrganization((ComplexMicrodata) microdata,
                    "http://localhost");
            if (org != null) {
                final String catid = org.getCat();
                if (catid != null) {
                    try {
                        final long catidl = Long.valueOf(catid);
                        if (!catList.contains(catidl)) {
                            if (org.getPhones() == null || org.getPhones().isEmpty()) {
                                exceptions.add(new YandexOrgTelMicrodataValidatorException(isCritical, "telephone",
                                        microdata));
                            }
                        }
                    } catch (NumberFormatException ex) {
                        if (org.getPhones() == null || org.getPhones().isEmpty()) {
                            exceptions.add(
                                    new YandexOrgTelMicrodataValidatorException(isCritical, "telephone", microdata));
                        }
                    }
                } else {
                    if (org.getPhones() == null || org.getPhones().isEmpty()) {
                        exceptions.add(new YandexOrgTelMicrodataValidatorException(isCritical, "telephone", microdata));
                    }
                }
            }
        }
        return Collections.unmodifiableList(exceptions);
    }
}
