package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.validators;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.ComplexMicrodata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.data.Microdata;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.MicrodataValidatorException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microdata.exceptions.NoFieldMicrodataValidatorException;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 11/8/11
 * Time: 5:53 AM
 */
public class YandexSOrgReviewMicrodataValidator implements MicrodataValidator {

    @Override
    public List<MicrodataValidatorException> validate(final Microdata microdata) {
        final List<MicrodataValidatorException> exceptions = new LinkedList<MicrodataValidatorException>();
        if (microdata instanceof ComplexMicrodata) {
            boolean hasMainText = false;
            if (((ComplexMicrodata) microdata).getFirst("description") != null) {
                hasMainText = true;
            }
            if (((ComplexMicrodata) microdata).getFirst("reviewBody") != null) {
                hasMainText = true;
            }
            if (((ComplexMicrodata) microdata).getFirst("pro") != null) {
                hasMainText = true;
            }
            if (((ComplexMicrodata) microdata).getFirst("contra") != null) {
                hasMainText = true;
            }
            if (!hasMainText) {
                exceptions.add(new NoFieldMicrodataValidatorException(false, "description | reviewBody | pro | contra",
                        microdata));
            }
            final Microdata item = ((ComplexMicrodata) microdata).getFirst("itemReviewed");
            if (item == null) {
                exceptions.add(new NoFieldMicrodataValidatorException(false, "itemReviewed", microdata));
            }
//            final Microdata reviewer = ((ComplexMicrodata) microdata).getFirst("author");
//            if (reviewer == null) {
//                exceptions.add(new NoFieldMicrodataValidatorException(false, "author", microdata));
//            } else {
//                if (reviewer instanceof ComplexMicrodata) {
//                    if (((ComplexMicrodata) reviewer).getFirst("name") == null) {
//                        exceptions.add(new NoFieldMicrodataValidatorException(false, "author.name", microdata));
//                    }
//                }
//            }
            if (((ComplexMicrodata) microdata).getFirst("datePublished") == null) {
                exceptions.add(new NoFieldMicrodataValidatorException(false, "datePublished", microdata));
            }
            if (((ComplexMicrodata) microdata).getFirst("url") == null) {
                exceptions.add(new NoFieldMicrodataValidatorException(false, "url", microdata));
            }
        }
        return Collections.unmodifiableList(exceptions);
    }
}
