package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data;

import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.location.EntityLocation;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidDataMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFType;

import java.util.List;

public abstract class MFPropertyData implements Cloneable {

    final MFProperty spec;

    private final EntityLocation location;

    public EntityLocation getLocation() {
        return location;
    }

    public MFPropertyData(@NotNull final MFProperty mfProperty) {
        spec = mfProperty;
        location = mfProperty.getLocation();
    }

    public MFProperty getSpec() {
        return spec;
    }

    public abstract boolean isEmpty();

    public abstract MFPropertyData clone();

    /**
     * Deprecated. Use MicroformatData.getDataAsList instead
     *
     * @return
     */
    @Deprecated
    public abstract List<MFAnyData> getDataAsList();

    @NotNull
    public String getName() {
        return spec.getName();
    }

    public List<MFType> getPossibleTypes() {
        return spec.getPossibleTypes();
    }

    public String toShortString() {
        try {
            return spec.toShortString(this);
        } catch (InvalidActionException e) {
            e.printStackTrace();  //cannot be
            return null;
        }
    }

    /**
     * Deprecated. Use MicroformatData.postProcess instead
     *
     *
     * @param content
     * @param node
     * @param microformatData
     * @throws MFException
     */
    @Deprecated
    public boolean postProcess(@NotNull final String content, final Node node, final MicroformatData microformatData) throws MFException {
        return spec.postProcess(this, content, node, microformatData);
    }

    /**
     * Deprecated. Use MicroformatData.addData instead
     *
     * @param newData
     * @throws InvalidDataMFException
     */
    @Deprecated
    public void addData(@NotNull final MFAnyData newData) throws InvalidDataMFException {
        spec.addData(this, newData);
    }
}
