package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.EmptyMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertyPlural;

import java.util.*;

public class MFPropertyPluralData extends MFPropertyData {

    private final List<MFAnyData> data = new ArrayList<MFAnyData>();
    private final Set<MFAnyData> dataSet = new HashSet<MFAnyData>();

    public MFPropertyPluralData(@NotNull final MFPropertyPlural mfPropertyPlural) {
        super(mfPropertyPlural);
    }

    @NotNull
    public List<MFAnyData> getData() {
        return Collections.unmodifiableList(data);
    }

    /**
     * Deprecated. Use MicroformatData.addData instead
     *
     * @param newData
     * @return
     */
    @Deprecated
    public boolean add(@NotNull final MFAnyData newData) throws EmptyMFException {
        if (newData.isEmpty()) {
            throw new EmptyMFException(getName());
        }
        final boolean res = dataSet.add(newData);
        //if (res) {
            data.add(newData);
        //}
        return res;
    }

    public boolean contains(final MFAnyData data) {
        return dataSet.contains(data);
    }

    @Override
    public boolean isEmpty() {
        return data.isEmpty();
    }

    @Override
    public MFPropertyPluralData clone() {
        final MFPropertyPluralData res = new MFPropertyPluralData((MFPropertyPlural) getSpec());
        for (final MFAnyData anyData : data) {
            try {
                res.add(anyData.clone());
            } catch (EmptyMFException e) {
                e.printStackTrace();  //can not be
            }
        }
        return res;
    }

    @Override
    public List<MFAnyData> getDataAsList() {
        return getData();
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MFPropertyPluralData)) {
            return false;
        }

        final MFPropertyPluralData that = (MFPropertyPluralData) o;

        return equalsIgnoreOrder(data, that.data);

    }

    @Override
    public int hashCode() {
        return data.hashCode();
    }

    private static boolean equalsIgnoreOrder(final List<MFAnyData> one, final List<MFAnyData> two) {
        if (one.size() != two.size()) {
            return false;
        }
        final List<MFAnyData> list = new ArrayList<MFAnyData>(one);
        for (final MFAnyData data : two) {
            if (!list.remove(data)) {
                return false;
            }
        }
        return true;
    }

    public void giveMethodsTo(final MFPropertyPlural other) {
        other.receiveMethods(new Methods());
    }

    public class Methods {
        private Methods() {
        }

        public boolean add(@NotNull final MFAnyData newData) throws EmptyMFException {
            return MFPropertyPluralData.this.add(newData);
        }
    }
}
