package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.yandex.common.util.collections.Cf;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.EmptyMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertySingular;

import java.util.List;

public class MFPropertySingularData extends MFPropertyData {

    private MFAnyData data;

    public MFPropertySingularData(@NotNull final MFPropertySingular mfPropertySingular) {
        super(mfPropertySingular);
    }

    @Nullable
    public MFAnyData getData() {
        return data;
    }

    /**
     * Deprecated. Use MicroformatData.addData instead
     *
     * @param data
     */
    @Deprecated
    public void setData(@Nullable final MFAnyData data) throws EmptyMFException {
        if (data.isEmpty()) {
            throw new EmptyMFException(getName());
        }
        this.data = data;
    }

    @Override
    public boolean isEmpty() {
        return data == null || data.isEmpty();
    }

    @Override
    public MFPropertySingularData clone() {
        final MFPropertySingularData res = new MFPropertySingularData((MFPropertySingular) getSpec());
        res.data = data.clone();
        return res;
    }

    @Override
    public List<MFAnyData> getDataAsList() {
        return Cf.list(getData());
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MFPropertySingularData)) {
            return false;
        }

        final MFPropertySingularData that = (MFPropertySingularData) o;

        final boolean empty = isEmpty();
        return !(empty != that.isEmpty() || (!empty && !data.equals(that.data)));

    }

    @Override
    public int hashCode() {
        return !isEmpty() ? data.hashCode() : 0;
    }

    public void giveMethodsTo(final MFPropertySingular other) {
        other.receiveMethods(new Methods());
    }

    public class Methods {
        private Methods() {
        }

        public void setData(@Nullable final MFAnyData data) throws EmptyMFException {
            MFPropertySingularData.this.setData(data);
        }
    }
}
