package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidDataMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFType;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.DatetimeProperty;

public class DatetimeData extends MFAnyData implements Concatenable {
    @NotNull
    public String datetime;

    public DatetimeData() {
        datetime = "";
    }

    public DatetimeData(@NotNull final String datetime) {
        this();
        this.datetime = datetime.trim();
    }

    @Override
    public String toString() {
        return datetime;
    }

    @Override
    public MFType getSpec() {
        return DatetimeProperty.getInstance();
    }

    @Override
    public boolean isEmpty() {
        return datetime.isEmpty();
    }

    @Override
    public DatetimeData clone() {
        return new DatetimeData(datetime);
    }

    @Override
    public String toShortString() {
        try {
            return getSpec().toShortString(this);
        } catch (InvalidActionException e) {
            e.printStackTrace();  //cannot be
            return null;
        }
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatetimeData)) {
            return false;
        }

        final DatetimeData datetimeData = (DatetimeData) o;

        return datetime.equals(datetimeData.datetime);

    }

    @Override
    public int hashCode() {
        return datetime.hashCode();
    }

    @Override
    public void append(final MFAnyData second) throws InvalidDataMFException {
        if (!(second instanceof DatetimeData)) {
            throw new InvalidDataMFException("can not concatenate data of different types");
        }
        datetime += " " + ((DatetimeData) second).datetime;
    }
}
