package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFType;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.FlagProperty;

public class FlagData extends MFAnyData {

    public FlagData() {
    }

    @Override
    public String toString() {
        return "true";
    }

    @Override
    public MFType getSpec() {
        return FlagProperty.getInstance();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public FlagData clone() {
        return new FlagData();
    }

    @Override
    public String toShortString() {
        try {
            return getSpec().toShortString(this);
        } catch (InvalidActionException e) {
            e.printStackTrace();  //cannot be
            return null;
        }
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof FlagData;
    }

    private final int HASH = 12341211;

    @Override
    public int hashCode() {
        return HASH;
    }
}
