package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFType;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.HTMLProperty;

public class HTMLData extends MFAnyData {
    @NotNull
    public String html;

    public HTMLData() {
        html = "";
    }

    public HTMLData(@NotNull final String html) {
        this();
        this.html = html.trim();
    }

    @Override
    public String toString() {
        return html;
    }

    @Override
    public MFType getSpec() {
        return HTMLProperty.getInstance();
    }

    @Override
    public boolean isEmpty() {
        return html.isEmpty();
    }

    @Override
    public HTMLData clone() {
        return new HTMLData(html);
    }

    @Override
    public String toShortString() {
        try {
            return getSpec().toShortString(this);
        } catch (InvalidActionException e) {
            e.printStackTrace();  //cannot be
            return null;
        }
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HTMLData)) {
            return false;
        }

        final HTMLData data = (HTMLData) o;

        return html.equals(data.html);

    }

    @Override
    public int hashCode() {
        return html.hashCode();
    }
}
