package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFType;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.IDProperty;

public class IDData extends MFAnyData {
    @NotNull
    public String id;

    public IDData() {
        id = "";
    }

    public IDData(@NotNull final String id) {
        this();
        this.id = id.trim();
    }

    @Override
    public String toString() {
        return id;
    }

    @Override
    public MFType getSpec() {
        return IDProperty.getInstance();
    }

    @Override
    public boolean isEmpty() {
        return id.isEmpty() || id.equals("#");
    }

    @Override
    public IDData clone() {
        return new IDData(id);
    }

    @Override
    public String toShortString() {
        try {
            return getSpec().toShortString(this);
        } catch (InvalidActionException e) {
            e.printStackTrace();  //cannot be
            return null;
        }
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IDData)) {
            return false;
        }

        final IDData idData = (IDData) o;

        return id.equals(idData.id);

    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }
}
