package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidDataMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFType;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.TextProperty;

public class TextData extends MFAnyData implements Concatenable {
    @NotNull
    public String text;

    public TextData() {
        text = "";
    }

    public TextData(@NotNull final String text) {
        this();
        this.text = text.trim();
    }

    @Override
    public String toString() {
        return text;
    }

    @Override
    public MFType getSpec() {
        return TextProperty.getInstance();
    }

    @Override
    public boolean isEmpty() {
        return text.isEmpty();
    }

    @Override
    public TextData clone() {
        return new TextData(text);
    }

    @Override
    public String toShortString() {
        try {
            return getSpec().toShortString(this);
        } catch (InvalidActionException e) {
            e.printStackTrace();  //cannot be
            return null;
        }
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextData)) {
            return false;
        }

        final TextData textData = (TextData) o;

        return text.equalsIgnoreCase(textData.text);

    }

    @Override
    public int hashCode() {
        return text.toLowerCase().hashCode();
    }

    @Override
    public void append(final MFAnyData second) throws InvalidDataMFException {
        if (!(second instanceof TextData)) {
            throw new InvalidDataMFException("can not concatenate data of different types");
        }
        text += ((TextData) second).text;
    }
}
