package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFType;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.URIProperty;

public class URIData extends MFAnyData {
    @NotNull
    public String uri;

    public URIData() {
        uri = "";
    }

    public URIData(@NotNull final String uri) {
        this();
        this.uri = uri.trim();
    }

    @Override
    public String toString() {
        return uri;
    }

    @Override
    public MFType getSpec() {
        return URIProperty.getInstance();
    }

    @Override
    public boolean isEmpty() {
        return uri.isEmpty();
    }

    @Override
    public URIData clone() {
        return new URIData(uri);
    }

    @Override
    public String toShortString() {
        try {
            return getSpec().toShortString(this);
        } catch (InvalidActionException e) {
            e.printStackTrace();  //cannot be
            return null;
        }
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof URIData)) {
            return false;
        }

        final URIData uriData = (URIData) o;

        return uri.equalsIgnoreCase(uriData.uri);

    }

    @Override
    public int hashCode() {
        return uri.toLowerCase().hashCode();
    }
}
