package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions;

import org.jetbrains.annotations.NotNull;
import ru.yandex.common.util.collections.Cf;
import ru.yandex.common.util.xml.Xmler;

import java.util.LinkedList;
import java.util.List;

import static ru.yandex.common.util.xml.Xmler.attribute;
import static ru.yandex.common.util.xml.Xmler.unescapedTag;

public abstract class AbstractExcpetionSerializer implements MFExceptionSerializer {
    static final public String startMainTag = "<error>";
    static final public String endMainTag = "</error>";
    static final public String startBoldTag = "<b>";
    static final public String endBoldTag = "</b>";
    static final public String separator = ".";
    static final public String altSeparator = "\\|";

    @Override
    public List<Xmler.Tag> toXML(@NotNull final MFException ex) {
        return toXML(ex, "");
    }

    protected List<Xmler.Tag> toXML(final MFException ex, final String prefix) {
        if (ex instanceof MFExceptions) {
            return toXML((MFExceptions) ex, prefix);
        }
        final StringBuilder sb = new StringBuilder();
        sb.append(ex.isCritical() ? getErrorWord() : getWarningWord()).append(": ");
        sb.append(getPrefix(ex));
        final String procMessage = ex.getMessage().replaceAll(altSeparator,getAltWord());
        sb.append(startBoldTag).append(procMessage).append(endBoldTag);
        sb.append(getSuffix(ex)).append(" ");
        final Xmler.Tag result = unescapedTag("error", attribute("card_hash", ex.getCard().hashCode()), sb.toString());
        return Cf.list(result);
    }

    protected List<Xmler.Tag> toXML(final MFExceptions exceptions, final String prefix) {
        final String newPrefix =
                prefix + (exceptions.getMessage().isEmpty() ? "" : exceptions.getMessage() + separator);
        final List<Xmler.Tag> result = new LinkedList<Xmler.Tag>();
        for (final MFException exception : exceptions.getExceptionsByTreeView()) {
            result.addAll(toXML(exception, newPrefix));
        }
        return result;
    }

    protected String getPrefix(final MFException ex) {
        if (ex instanceof EmptyMFException) {
            return getMessagePrefix((EmptyMFException) ex);
        }
        if (ex instanceof MultipleDefinitionsForSingularMFException) {
            return getMessagePrefix((MultipleDefinitionsForSingularMFException) ex);
        }
        if (ex instanceof PropertyNotDefinedMFException) {
            return getMessagePrefix((PropertyNotDefinedMFException) ex);
        }
        if (ex instanceof InvalidDataMFException) {
            return getMessagePrefix((InvalidDataMFException) ex);
        }
        if (ex instanceof MaxDepthMFException) {
            return getMessagePrefix((MaxDepthMFException) ex);
        }
        if (ex instanceof NotOrgMFException) {
            return getMessagePrefix((NotOrgMFException) ex);
        }
        return getMessagePrefix(ex);
    }

    protected String getSuffix(final MFException ex) {
        if (ex instanceof EmptyMFException) {
            return getMessageSuffix((EmptyMFException) ex);
        }
        if (ex instanceof MultipleDefinitionsForSingularMFException) {
            return getMessageSuffix((MultipleDefinitionsForSingularMFException) ex);
        }
        if (ex instanceof PropertyNotDefinedMFException) {
            return getMessageSuffix((PropertyNotDefinedMFException) ex);
        }
        if (ex instanceof InvalidDataMFException) {
            return getMessageSuffix((InvalidDataMFException) ex);
        }
        if (ex instanceof MaxDepthMFException) {
            return getMessageSuffix((MaxDepthMFException) ex);
        }
        if (ex instanceof NotOrgMFException) {
            return getMessageSuffix((NotOrgMFException) ex);
        }
        return getMessageSuffix(ex);
    }

    protected abstract String getAltWord();

    protected abstract String getErrorWord();

    protected abstract String getWarningWord();

    protected abstract String getMessagePrefix(final EmptyMFException ex);

    protected abstract String getMessageSuffix(final EmptyMFException ex);

    protected abstract String getMessagePrefix(final MultipleDefinitionsForSingularMFException ex);

    protected abstract String getMessageSuffix(final MultipleDefinitionsForSingularMFException ex);

    protected abstract String getMessagePrefix(final PropertyNotDefinedMFException ex);

    protected abstract String getMessageSuffix(final PropertyNotDefinedMFException ex);

    protected abstract String getMessagePrefix(final InvalidDataMFException ex);

    protected abstract String getMessageSuffix(final InvalidDataMFException ex);

    protected abstract String getMessagePrefix(final MaxDepthMFException ex);

    protected abstract String getMessageSuffix(final MaxDepthMFException ex);

    protected abstract String getMessagePrefix(final NotOrgMFException ex);

    protected abstract String getMessageSuffix(final NotOrgMFException ex);

    protected abstract String getMessagePrefix(final MFException ex);

    protected abstract String getMessageSuffix(final MFException ex);
}
