package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.validators.MessageStorage;

public class ConfigurableMFExceptionSerializer extends AbstractExcpetionSerializer {

    private final MessageStorage messageStorage;
    private final String lang;
    private static final String ALT_WORD = "alt_word";
    private static final String ERROR_WORD = "error_word";
    private static final String WARNING_WORD = "warning_word";
    private static final String EMPTY = "empty";
    private static final String MULTIPLE = "multiple";
    private static final String PROP_NOT_DEF = "property_not_found";
    private static final String INVALID = "invalid";
    private static final String MAX_DEPTH = "max_depth";
    private static final String NOT_ORG = "not_org";
    private static final String GENERAL = "general";

    public ConfigurableMFExceptionSerializer(final MessageStorage messageStorage, final String lang) {
        this.messageStorage = messageStorage;
        this.lang = lang;
    }

    private String getMsg(final String key){
        return messageStorage.getMessage(lang,key);
    }

    @Override
    protected String getAltWord() {
        return getMsg(ALT_WORD);
    }

    @Override
    protected String getErrorWord() {
        return getMsg(ERROR_WORD);
    }

    @Override
    protected String getWarningWord() {
        return getMsg(WARNING_WORD);
    }

    @Override
    protected String getMessagePrefix(final EmptyMFException ex) {
        return getMsg(EMPTY+"_prefix");
    }

    @Override
    protected String getMessageSuffix(final EmptyMFException ex) {
        return getMsg(EMPTY)+"_suffix";
    }

    @Override
    protected String getMessagePrefix(final MultipleDefinitionsForSingularMFException ex) {
        return getMsg(MULTIPLE)+"_prefix";
    }

    @Override
    protected String getMessageSuffix(final MultipleDefinitionsForSingularMFException ex) {
        return getMsg(MULTIPLE)+"_suffix";
    }

    @Override
    protected String getMessagePrefix(final PropertyNotDefinedMFException ex) {
        return getMsg(PROP_NOT_DEF)+"_prefix";
    }

    @Override
    protected String getMessageSuffix(final PropertyNotDefinedMFException ex) {
        return getMsg(PROP_NOT_DEF)+"_suffix";
    }

    @Override
    protected String getMessagePrefix(final InvalidDataMFException ex) {
        return getMsg(INVALID)+"_prefix";
    }

    @Override
    protected String getMessageSuffix(final InvalidDataMFException ex) {
        return getMsg(INVALID)+"_suffix";
    }

    @Override
    protected String getMessagePrefix(final MaxDepthMFException ex) {
        return getMsg(MAX_DEPTH)+"_prefix";
    }

    @Override
    protected String getMessageSuffix(final MaxDepthMFException ex) {
        return getMsg(MAX_DEPTH)+"_suffix";
    }

    @Override
    protected String getMessagePrefix(final NotOrgMFException ex) {
        return getMsg(NOT_ORG+"_prefix");
    }

    @Override
    protected String getMessageSuffix(final NotOrgMFException ex) {
        return getMsg(NOT_ORG+"_suffix");
    }

    @Override
    protected String getMessagePrefix(final MFException ex) {
        return getMsg(GENERAL)+"_prefix";
    }

    @Override
    protected String getMessageSuffix(final MFException ex) {
        return getMsg(GENERAL)+"_suffix";
    }
}
