package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.exceptions.VerifierException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.location.EntityLocation;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;

public abstract class MFException extends VerifierException {
    final private boolean critical;
    private MicroformatData card;
    private final String message;

    public MFException(final String name) {
        this(name, true);

    }

    public MFException(final String name, final boolean critical) {
        message = name;
        this.critical = critical;
        this.location=EntityLocation.DEFAULT_LOCATION;
    }

    public MFException(final String name, final EntityLocation location) {
        message = name;
        this.critical = true;
        this.location = location;
    }

    public MFException(final String name, final boolean critical, final EntityLocation location) {
        message = name;
        this.critical = critical;
        this.location = location;
    }


    public boolean isCritical() {
        return critical;
    }

    public void setCard(final MicroformatData card) {
        this.card = card;
    }

    public MicroformatData getCard() {
        return card;
    }

    @Override
    public int getHash() {
        return card.number;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public boolean getSeverity() {
        return isCritical();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MFException that = (MFException) o;

        if (critical != that.critical) return false;
        if (card != null ? !card.equals(that.card) : that.card != null) return false;
        return !(message != null ? !message.equals(that.message) : that.message != null);

    }

    @Override
    public int hashCode() {
        int result = (critical ? 1 : 0);
        result = 31 * result + (card != null ? card.hashCode() : 0);
        result = 31 * result + (message != null ? message.hashCode() : 0);
        return result;
    }


    protected final EntityLocation location;

    public String getLocation() {
        if(null!=location) {
            return location.toString();
        }else{
            return "-1:-1";
        }
    }

//    public void setLocation(EntityLocation location) {
//        this.location = location;
//    }
}
