package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions;

import ru.yandex.webmaster3.core.semantic.semantic_document_parser.tanker.LanguageContext;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by IntelliJ IDEA.
 * User: rasifiel
 * Date: 14.09.12
 * Time: 18:19
 */
public class MFExceptionSerializerFactory {

    private static Map<LanguageContext, MFExceptionSerializer> serializerMap =
            new ConcurrentHashMap<LanguageContext, MFExceptionSerializer>();

    public MFExceptionSerializer createSerializer(final LanguageContext context) {
        if (serializerMap.containsKey(context)) {
            return serializerMap.get(context);
        } else {
            final MFExceptionSerializer serializer = new TankerMFExceptionSerializer(context);
            serializerMap.put(context, serializer);
            return serializer;
        }
    }
}
