package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions;

import ru.yandex.common.util.collections.Cu;
import ru.yandex.common.util.functional.Function;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.exceptions.PrefixException;

import java.util.Collection;
import java.util.List;

/**
 * Created by aleksart on 30.03.15.
 */
public class PrefixMicroformatExceptionWrapper extends MFException implements PrefixException {

    final MFException ex;
    final String prefix;

    public PrefixMicroformatExceptionWrapper(MFException ex, String prefix) {
        super(ex.getMessage(),ex.isCritical(), ex.location);
        this.ex = ex;
        this.prefix = prefix;
        this.setCard(ex.getCard());
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getKey() {
        return ex.getKey();
    }

    public static List<PrefixMicroformatExceptionWrapper> wrapAll(Collection<MFException> exs, final String prefix) {
        return Cu.map(new Function<MFException, PrefixMicroformatExceptionWrapper>() {
            @Override
            public PrefixMicroformatExceptionWrapper apply(final MFException e) {
                return new PrefixMicroformatExceptionWrapper(e, prefix);
            }
        }, exs);
    }
}
