package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec;

import org.htmlcleaner.TagNode;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;
import ru.yandex.common.util.collections.Cf;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.location.EntityLocation;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFPropertyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidDataMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFException;

import java.util.Collections;
import java.util.List;

public abstract class MFProperty {
    private final String name;
    private final List<MFType> possibleTypes;

    public MFProperty(@NotNull final String name, @NotNull final MFType... possibleTypes) {
        this.name = name;
        this.possibleTypes = Collections.unmodifiableList(Cf.list(possibleTypes));
    }


    private  EntityLocation location = EntityLocation.DEFAULT_LOCATION;

    public EntityLocation getLocation() {
        return location;
    }

    public void setLocation(EntityLocation location) {
        this.location = location;
    }

    @NotNull
    public String getName() {
        return name;
    }

    public List<MFType> getPossibleTypes() {
        return possibleTypes;
    }

    // === abstracts

    /**
     * Deprecated. Use Microformat.addData or MicroformatData.addData instead
     *
     * @return
     */
    @Deprecated
    public abstract MFPropertyData createData();

    public abstract String toShortString(@NotNull final MFPropertyData mfPropertyData) throws InvalidActionException;

    public abstract String toDebugString(@NotNull final MFPropertyData mfPropertyData, @NotNull final String indent) throws InvalidActionException;

    public abstract boolean postProcess(final MFPropertyData mfPropertyData, @NotNull final String content, final Node node, final MicroformatData microformatData) throws MFException;

    public abstract boolean postProcess(final MFPropertyData mfPropertyData, @NotNull final String content, final TagNode node, final MicroformatData microformatData) throws MFException;


    public abstract void addData(@NotNull final MFPropertyData data, @NotNull final MFAnyData newData) throws InvalidDataMFException;

    // === implementation

    public String toShortString(@NotNull final MFAnyData data) throws InvalidActionException {
        return data.getSpec().toShortString(data);
    }

    public String toDebugString(@NotNull final MFAnyData data, @NotNull final String indent) throws InvalidActionException {
        return data.getSpec().toDebugString(data, indent);
    }
}
