package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFPropertySingularData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types.Concatenable;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidDataMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MultipleDefinitionsForSingularMFException;

public class MFPropertyConcatenated extends MFPropertySingular {

    public MFPropertyConcatenated(@NotNull final String name, @NotNull final MFType... possibleTypes) {
        super(name, possibleTypes);
    }

    @Override
    public void addData(@NotNull final MFPropertySingularData data, @NotNull final MFAnyData newData) throws InvalidDataMFException {
        try {
            super.addData(data, newData);
        } catch (MultipleDefinitionsForSingularMFException e) {
            if (data.getData() instanceof Concatenable) {
                ((Concatenable) data.getData()).append(newData);
            } else {
                throw e;
            }
        }
    }
}
