package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec;

import org.htmlcleaner.TagNode;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFPropertyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFPropertyPluralData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidDataMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFException;

public class MFPropertyPlural extends MFProperty {

    public MFPropertyPlural(@NotNull final String name, @NotNull final MFType... possibleTypes) {
        super(name, possibleTypes);
    }

    @Override
    public MFPropertyPluralData createData() {
        return new MFPropertyPluralData(this);
    }

    @Override
    public String toShortString(@NotNull final MFPropertyData mfPropertyData) throws InvalidActionException {
        final StringBuilder sb = new StringBuilder();
        for (final MFAnyData data : ((MFPropertyPluralData) mfPropertyData).getData()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(toShortString(data));
        }
        return sb.toString();
    }

    @Override
    public String toDebugString(@NotNull final MFPropertyData mfPropertyData, @NotNull final String indent) throws InvalidActionException {
        final StringBuilder sb = new StringBuilder();
        for (final MFAnyData data : ((MFPropertyPluralData) mfPropertyData).getData()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(toDebugString(data, indent));
        }
        return sb.toString();
    }

    @Override
    synchronized public void addData(@NotNull final MFPropertyData data, @NotNull final MFAnyData newData) throws InvalidDataMFException {
        //((MFPropertyPluralData)data).add(newData);
        final MFPropertyPluralData pluralData = (MFPropertyPluralData) data;
        pluralData.giveMethodsTo(this);
        methods.add(newData);
        methods = null;
    }

    @Override
    public final boolean postProcess(final MFPropertyData mfPropertyData, @NotNull final String content, final Node node, final MicroformatData microformatData) throws MFException {
        return postProcess((MFPropertyPluralData) mfPropertyData, content);
    }

    @Override
    public boolean postProcess(MFPropertyData mfPropertyData, @NotNull String content, TagNode node, MicroformatData microformatData) throws MFException {
        return false;
    }

    /**
     * Override it to change post processing for existing plural properties
     * It does not need to be overriden if you overrided post processing for microformat
     *
     * @param data
     * @param content
     * @throws MFException
     */
    public boolean postProcess(final MFPropertyPluralData data, final String content) throws MFException {
        return false;
    }

    protected MFPropertyPluralData.Methods methods; //temporal data

    synchronized public void receiveMethods(final MFPropertyPluralData.Methods methods) {
        this.methods = methods;
    }
}
