package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFPropertyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFPropertyPluralData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidDataMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MultipleDefinitionsForSingularMFException;

public class MFPropertySingularSpec extends MFPropertyPlural {
    public MFPropertySingularSpec(@NotNull final String name, @NotNull final MFType... possibleTypes) {
        super(name, possibleTypes);
    }

    @Override
    public void addData(@NotNull final MFPropertyData data, @NotNull final MFAnyData newData) throws InvalidDataMFException {
        final MFPropertyPluralData pluralData = (MFPropertyPluralData) data;
        for (final MFAnyData anyData : pluralData.getData()) {
            if (anyData.getSpec() == newData.getSpec()) {
                throw new MultipleDefinitionsForSingularMFException(getName(), data.getLocation());
            }
        }
        super.addData(data, newData);
    }
}
