package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec;

import org.htmlcleaner.TagNode;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFPropertySingularData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types.TelURIData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types.TextData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types.URIData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.EmptyMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.TelURIProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.TextProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.URIProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.transformer.Tu;

public class MFPropertyValue extends MFPropertyConcatenated {

    public MFPropertyValue() {
        this("value");
    }

    public MFPropertyValue(@NotNull final MFType... types) {
        this("value", types);
    }

    public MFPropertyValue(@NotNull final String name, @NotNull final MFType... types) {
        super(name, types);
    }

    public MFPropertyValue(@NotNull final String name) {
        this(name, URIProperty.getInstance(), TextProperty.getInstance());
    }

    synchronized public boolean postProcess(MFPropertySingularData data, @NotNull final String content, final Node node, final MicroformatData microformatData) {
        try {
            if (!content.isEmpty() && (data==null|| data.isEmpty())) {
                if (data==null) {
                    MFPropertySingularData newData = new MFPropertySingularData(this);
                    microformatData.put(this.getName(),newData);
                    return postProcess(newData,content,node,microformatData);
                }
                if (getPossibleTypes().contains(URIProperty.getInstance())) {
                    //data.setData(new TextData(content));
                    data.giveMethodsTo(this);
                    methods.setData(new URIData(Tu.getUriValue((Element) node, false)));
                    methods = null;
                    return true;
                } else if (getPossibleTypes().contains(TelURIProperty.getInstance())) {
                    //data.setData(new TextData(content));
                    data.giveMethodsTo(this);
                    methods.setData(new TelURIData(Tu.getUriValue((Element) node, false)));
                    methods = null;
                    return true;
                } else if (getPossibleTypes().contains(TextProperty.getInstance())) {
                    //data.setData(new TextData(content));
                    data.giveMethodsTo(this);
                    methods.setData(new TextData(content));
                    methods = null;
                    return true;
                }
            }
        } catch (final EmptyMFException ex) {
            //ignore
        }
        return false;
    }

    synchronized public boolean postProcess(MFPropertySingularData data, @NotNull String content, final TagNode node, final MicroformatData microformatData) throws MFException {
        try {
            if (!content.isEmpty() && (data==null|| data.isEmpty())) {
                if (data==null) {
                    MFPropertySingularData newData = new MFPropertySingularData(this);
                    microformatData.put(this.getName(),newData);
                    return postProcess(newData,content,node,microformatData);
                }
                if (getPossibleTypes().contains(URIProperty.getInstance())) {
                    //data.setData(new TextData(content));
                    data.giveMethodsTo(this);
                    methods.setData(new URIData(Tu.getUriValue(node, false)));
                    methods = null;
                    return true;
                } else if (getPossibleTypes().contains(TelURIProperty.getInstance())) {
                    //data.setData(new TextData(content));
                    data.giveMethodsTo(this);
                    methods.setData(new TelURIData(Tu.getUriValue(node, false)));
                    methods = null;
                    return true;
                } else if (getPossibleTypes().contains(TextProperty.getInstance())) {
                    //data.setData(new TextData(content));
                    data.giveMethodsTo(this);
                    methods.setData(new TextData(content));
                    methods = null;
                    return true;
                }
            }
        } catch (final EmptyMFException ex) {
            //ignore
        }
        return false;
    }
}
