package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertyPlural;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.Microformat;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.TextProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;

public class Adr extends Microformat {
    final private static Adr instance = new Adr("adr", true);

    /**
     * the name should be equal to the header of microformat (e. g. "vcard")
     *
     * @param name
     */
    protected Adr(@NotNull final String name, final boolean root) {
        super(name, root);
    }

    static {
        try {
            instance.addProperty(new MFPropertyPlural("country-name", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("postal-code", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("region", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("locality", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("street-address", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("extended-address", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("post-office-box", TextProperty.getInstance()));
        } catch (InvalidActionException e) {
            e.printStackTrace();
        }
        instance.freeze();
    }

    public static Adr getInstance() {
        return instance;
    }
}
