package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances;

import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types.TextData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidDataMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFExceptions;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.*;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.TextProperty;

public class AggregateRating extends Microformat {
    final private static AggregateRating instance = new AggregateRating("rating", false);
    private static MFProperty worst, best;

    /**
     * the name should be equal to the header of microformat (e. g. "vcard")
     *
     * @param name
     */
    protected AggregateRating(@NotNull final String name, final boolean root) {
        super(name, root);
    }

    static {
        try {
            instance.addProperty(new MFPropertyValue("average", TextProperty.getInstance()));
            instance.addProperty(worst = new MFPropertySingular("worst", TextProperty.getInstance()));
            instance.addProperty(best = new MFPropertySingular("best", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyRel("tag"));
        } catch (InvalidActionException e) {
            e.printStackTrace();
        }
        instance.freeze();
    }

    public static AggregateRating getInstance() {
        return instance;
    }

    @Override
    public boolean postProcess(@NotNull final MicroformatData data, @NotNull final String content, final Node node) throws InvalidActionException, MFExceptions {
        boolean res = false;
        final MFExceptions ex = new MFExceptions(getName());
        try {
            res = super.postProcess(data, content, node);
        } catch (MFException e) {
            ex.put(e);
        }
        if (data.isEmpty(worst.getName())) {
            try {
                data.addData(worst, new TextData("1.0"));
            } catch (InvalidDataMFException e) {
                e.printStackTrace();  //cannot be
            }
        }
        if (data.isEmpty(best.getName())) {
            try {
                data.addData(best, new TextData("5.0"));
            } catch (InvalidDataMFException e) {
                e.printStackTrace();  //cannot be
            }
        }
        if (!ex.isEmpty()) {
            throw ex;
        }
        return res;
    }
}
