package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances;

import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types.TextData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.*;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.Microformat;

public class ExperienceHCard extends Microformat {
    final private static ExperienceHCard instance = new ExperienceHCard("vcard", false);

    /**
     * the name should be equal to the header of microformat (e. g. "vcard")
     *
     * @param name
     */
    protected ExperienceHCard(@NotNull final String name, final boolean root) {
        super(name, root);
    }

    static {
        try {
            for (final MFProperty property : HCard.getInstance().getProperties()) {
                instance.addProperty(property);
            }
        } catch (InvalidActionException e) {
            e.printStackTrace();
        }
        instance.freeze();
    }

    public static ExperienceHCard getInstance() {
        return instance;
    }

    public boolean isOrganization(@NotNull final MicroformatData data) {
        try {
            final MFAnyData fn = data.getFirstOrNull("fn");
            if (fn == null) {
                return false;
            }
            for (final MFAnyData anyData : data.getDataAsList("org")) {
                if (contains(anyData, fn)) {
                    return true;
                }
            }
            for (final MFAnyData anyData : data.getDataAsList("adr")) {
                if (contains(anyData, fn)) {
                    return true;
                }
            }
            return false;
        } catch (final Exception ex) {
            return false;
        }
    }

    @Override
    public boolean postProcess(@NotNull final MicroformatData data, @NotNull final String content, final Node node) throws EmptyMFException, InvalidActionException, MFExceptions {
        if (data.isEmpty()) {
            throw new EmptyMFException(getName());
        }
        final MFExceptions ex = new MFExceptions(getName());
        if (data.isEmpty("fn")) {
            //check required
            ex.put(new PropertyNotDefinedMFException("fn"));
            throw ex;
        }
        final boolean org = isOrganization(data);
        if (org) {
            data.remove("n");
        }
        if (!org && data.isEmpty("n")) {
            try {
                final String fn = ((TextData) data.getDataAsList("fn").get(0)).text;
                try {
                    //Implied "N" Optimization
                    final MicroformatData nData = N.getInstance().createData();
                    nData.getSpec().postProcess(nData, fn, node);
                    addData(data, getProperty("n"), nData);
                } catch (MFException e) {
                    //Implied "nickname" Optimization
                    if (data.isEmpty(getProperty("nickname").getName())) {
                        final String[] parts = fn.trim().split("\\s+");
                        if (parts.length != 1) {
                            ex.put(new InvalidDataMFException("n", false));
                            throw ex;
                        }
                        addData(data, getProperty("nickname"), new TextData(parts[0]));
                    }
                }
            } catch (InvalidDataMFException e) {
                //check required
                ex.put(new PropertyNotDefinedMFException("n", false));
                throw ex;
            }
        }
        if (!org && !data.isEmpty("n") && data.getDataAsList("n").get(0) instanceof TextData) {
            //Implied "N" Optimization
            try {
                final MicroformatData nData = N.getInstance().createData();
                nData.getSpec().postProcess(nData, ((TextData) data.getDataAsList("n").get(0)).text, node);
                data.remove("n");
                addData(data, getProperty("n"), nData);
            } catch (MFException e) {
                //ignore
            }
        }
        if (!ex.isEmpty()) {
            throw ex;
        }
        return false;
    }

    private boolean contains(final MFAnyData data, final MFAnyData some) {
        if (data.equals(some)) {
            return true;
        }
        if (!(data instanceof MicroformatData)) {
            return false;
        }
        final MicroformatData microformatData = (MicroformatData) data;
        for (final MFProperty property : microformatData.getProperties()) {
            for (final MFAnyData anyData : microformatData.getDataAsList(property.getName())) {
                if (contains(anyData, some)) {
                    return true;
                }
            }
        }
        return false;
    }
}
