package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertySingular;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.Microformat;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.TextProperty;

public class GoogleNutrition extends Microformat {
    final private static GoogleNutrition instance = new GoogleNutrition("nutrition", false);

    /**
     * the name should be equal to the header of microformat (e. g. "vcard")
     *
     * @param name
     */
    protected GoogleNutrition(@NotNull final String name, final boolean root) {
        super(name, root);
    }

    static {
        try {
            instance.addProperty(new MFPropertySingular("calories", TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("fat", TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("saturatedFat", TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("unsaturatedFat", TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("carbohydrates", TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("sugar", TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("fiber", TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("protein", TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("cholesterol", TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("servingSize", TextProperty.getInstance()));
        } catch (InvalidActionException e) {
            e.printStackTrace();
        }
        instance.freeze();
    }

    public static GoogleNutrition getInstance() {
        return instance;
    }
}
