package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertyPlural;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertyRel;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.Microformat;

public class HAtom extends Microformat {
    final private static HAtom instance = new HAtom("hfeed", true);

    /**
     * the name should be equal to the header of microformat (e. g. "vcard")
     *
     * @param name
     */
    protected HAtom(@NotNull final String name, final boolean root) {
        super(name, root);
    }

    static {
        try {
            instance.addProperty(new MFPropertyRel("tag"));
            instance.addProperty(new MFPropertyPlural("hentry", HEntry.getInstance()));
        } catch (InvalidActionException e) {
            e.printStackTrace();
        }
        instance.freeze();
    }

    public static HAtom getInstance() {
        return instance;
    }
}
