package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertyPlural;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertyRel;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.Microformat;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.DatetimeProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.TextProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.URIProperty;

public class HAudio extends Microformat {
    final private static HAudio instance = new HAudio("haudio", true);

    /**
     * the name should be equal to the header of microformat (e. g. "vcard")
     *
     * @param name
     */
    protected HAudio(@NotNull final String name, final boolean root) {
        super(name, root);
    }

    static {
        try {
            instance.addProperty(new MFPropertyPlural("item",ItemHAudio.getInstance(),TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("fn", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("album", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("contributor", HCard.getInstance(),TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("duration", DatetimeProperty.getInstance()));
            instance.addProperty(new MFPropertyRel("principles"));
            instance.addProperty(new MFPropertyPlural("position", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("category", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("published", DatetimeProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("photo", URIProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("description", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyRel("sample"));
            instance.addProperty(new MFPropertyRel("tag"));
            instance.addProperty(new MFPropertyRel("enclosure"));
            instance.addProperty(new MFPropertyRel("payment"));
            instance.addProperty(new MFPropertyPlural("price", Price.getInstance(), TextProperty.getInstance()));
        } catch (InvalidActionException e) {
            e.printStackTrace();
        }
        instance.freeze();
    }

    public static HAudio getInstance() {
        return instance;
    }
}
