package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances;

import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types.TextData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.*;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.*;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.IDProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.TelURIProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.TextProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.URIProperty;

public class HCard extends Microformat {
    final private static HCard instance = new HCard("vcard", true);
    private static MFProperty n, nickname;

    /**
     * the name should be equal to the header of microformat (e. g. "vcard")
     *
     * @param name
     */
    protected HCard(@NotNull final String name, final boolean root) {
        super(name, root);
    }

    static {
        try {
            instance.addProperty(new MFPropertySingular("fn", TextProperty.getInstance()));
            instance.addProperty(n = new MFPropertySingular("n", N.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("adr", Adr.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("agent", TextProperty.getInstance(), HCard.getInstance()));
            instance.addProperty(new MFPropertySingular("bday", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("category", TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("class", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("email", Email.getInstance(), URIProperty.getInstance(),
                    TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("geo", Geo.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("key", URIProperty.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("label", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("logo", URIProperty.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("mailer", TextProperty.getInstance()));
            instance.addProperty(nickname = new MFPropertyPlural("nickname", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("note", TextProperty.getInstance()));
            instance.addProperty(
                    new MFPropertyPlural("org", Org.getInstance(), TextProperty.getInstance(), HCard.getInstance()));
            instance.addProperty(new MFPropertyPlural("photo", URIProperty.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("rev", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("role", TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("sort-string", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("sound", URIProperty.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("tel", Tel.getInstance(), TelURIProperty.getInstance(),
                    TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("title", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("altname", TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("uid", IDProperty.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("url", URIProperty.getInstance(), TextProperty.getInstance()));
            instance.addProperty(
                    new MFPropertyPlural("permalink", URIProperty.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("workhours", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyRel("tag"));
        } catch (InvalidActionException e) {
            e.printStackTrace();
        }
        instance.freeze();
    }

    public static HCard getInstance() {
        return instance;
    }

    public boolean isOrganization(@NotNull final MicroformatData data) {
        try {
            final MFAnyData fn = data.getFirstOrNull("fn");
            if (fn == null) {
                return false;
            }
            for (final MFAnyData anyData : data.getDataAsList("org")) {
                if (contains(anyData, fn)) {
                    return true;
                }
            }
            for (final MFAnyData anyData : data.getDataAsList("adr")) {
                if (contains(anyData, fn)) {
                    return true;
                }
            }
            return false;
        } catch (final Exception ex) {
            return false;
        }
    }

    @Override
    public boolean postProcess(@NotNull final MicroformatData data, @NotNull final String content, final Node node) throws EmptyMFException, InvalidActionException, MFExceptions {
        if (data.isEmpty()) {
            throw new EmptyMFException(getName());
        }
        final MFExceptions ex = new MFExceptions(getName());
        if (data.isEmpty("fn")) {
            //check required
            ex.put(new PropertyNotDefinedMFException("fn", data.getLocation()),"hCard_condition");
            throw ex;
        }
        final boolean org = isOrganization(data);
        if (org) {
            data.remove("n");
            if (data.isEmpty("tel")) {
                ex.put(new PropertyNotDefinedMFException("tel", false, data.getLocation()),"hCard_condition");
            }
            if (data.isEmpty("adr")) {
                ex.put(new PropertyNotDefinedMFException("adr", false, data.getLocation()),"hCard_condition");
            }
        }
        if (!org && data.isEmpty("n")) {
            try {
                final String fn = ((TextData) data.getDataAsList("fn").get(0)).text;
                try {
                    //Implied "N" Optimization
                    final MicroformatData nData = N.getInstance().createData();
                    nData.getSpec().postProcess(nData, fn, node);
                    addData(data, n , nData);
                } catch (MFException e) {
                    //Implied "nickname" Optimization
                    if (data.isEmpty(nickname.getName())) {
                        final String[] parts = fn.trim().split("\\s+");
                        if (parts.length != 1) {
                            //ex.put(new InvalidDataMFException("n", false, data.getLocation()));
                            throw ex;
                        }
                        addData(data, nickname, new TextData(parts[0]));
                    }
                }
            } catch (InvalidDataMFException e) {
                //ignore
                //ex.put(new PropertyNotDefinedMFException("n", false, data.getLocation()),"hReview_condition");
                //throw ex;
            }
        }
        if (!org && !data.isEmpty("n") && data.getDataAsList("n").get(0) instanceof TextData) {
            //Implied "N" Optimization
            try {
                final MicroformatData nData = N.getInstance().createData();
                nData.getSpec().postProcess(nData, ((TextData) data.getDataAsList("n").get(0)).text, node);
                data.remove("n");
                addData(data, n, nData);
            } catch (MFException e) {
                //ignore
            }
        }
        if (!ex.isEmpty()) {
            throw ex;
        }
        return false;
    }

    private boolean contains(final MFAnyData data, final MFAnyData some) {
        if (data.equals(some)) {
            return true;
        }
        if (!(data instanceof MicroformatData)) {
            return false;
        }
        final MicroformatData microformatData = (MicroformatData) data;
        for (final MFProperty property : microformatData.getProperties()) {
            for (final MFAnyData anyData : microformatData.getDataAsList(property.getName())) {
                if (contains(anyData, some)) {
                    return true;
                }
            }
        }
        return false;
    }
}
