package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertyPlural;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertyRel;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertySingular;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.Microformat;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.DatetimeProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.TextProperty;

public class HEntry extends Microformat {
    final private static HEntry instance = new HEntry("hentry", false);

    /**
     * the name should be equal to the header of microformat (e. g. "vcard")
     *
     * @param name
     */
    protected HEntry(@NotNull final String name, final boolean root) {
        super(name, root);
    }

    static {
        try {
            instance.addProperty(new MFPropertySingular("entry-title", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("entry-content", TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("entry-summary", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("updated", DatetimeProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("published", DatetimeProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("author", HCard.getInstance()));
            instance.addProperty(new MFPropertyRel("bookmark"));
            instance.addProperty(new MFPropertyRel("tag"));
        } catch (InvalidActionException e) {
            e.printStackTrace();
        }
        instance.freeze();
    }

    public static HEntry getInstance() {
        return instance;
    }
}
