package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances;

import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.EmptyMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFExceptions;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.PropertyNotDefinedMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertyPlural;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertyRel;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertySingular;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.Microformat;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.FlagProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.TextProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.URIProperty;

public class HListing extends Microformat {
    final private static HListing instance = new HListing("hmedia", true);

    /**
     * the name should be equal to the header of microformat (e. g. "vcard")
     *
     * @param name
     */
    protected HListing(@NotNull final String name, final boolean root) {
        super(name, root);
    }

    final static String[] listingType = {"offer", "wanted"};
    final static String[] listingActions = {"sell", "rent", "trade", "meet", "announce", "event", "service"};

    static {
        try {
            instance.addProperty(new MFPropertyPlural("version", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("lister", HCard.getInstance()));
            instance.addProperty(
                    new MFPropertySingular("photo", URIProperty.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("player", URIProperty.getInstance()));
            instance.addProperty(new MFPropertyRel("enclosure", URIProperty.getInstance()));
            for (final String action : listingActions) {
                instance.addProperty(new MFPropertySingular(action, FlagProperty.getInstance()));
            }
        } catch (InvalidActionException e) {
            e.printStackTrace();
        }
        instance.freeze();
    }

    public static HListing getInstance() {
        return instance;
    }

    @Override
    public boolean postProcess(@NotNull final MicroformatData data, @NotNull final String content, final Node node) throws EmptyMFException, MFExceptions, InvalidActionException {
        if (data.isEmpty()) {
            throw new EmptyMFException(getName());
        }
        final MFExceptions ex = new MFExceptions(getName());
        if (data.isEmpty("fn")) {
            ex.put(new PropertyNotDefinedMFException("fn", data.getLocation()));
        }
        if (!ex.isEmpty()) {
            throw ex;
        }
        return false;
    }
}
