package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertyPlural;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertyRel;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertySingular;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.Microformat;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.TextProperty;

public class HNews extends Microformat {
    final private static HNews instance = new HNews("hnews", true);

    /**
     * the name should be equal to the header of microformat (e. g. "vcard")
     *
     * @param name
     */
    protected HNews(@NotNull final String name, final boolean root) {
        super(name, root);
    }

    static {
        try {
            instance.addProperty(new MFPropertyPlural("hentry", HEntry.getInstance()));
            instance.addProperty(new MFPropertyPlural("source-org", HCard.getInstance()));
            instance.addProperty(new MFPropertySingular("dateline", HCard.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("geo", Geo.getInstance()));
            instance.addProperty(new MFPropertyRel("item-license"));
            instance.addProperty(new MFPropertyRel("principles"));
        } catch (InvalidActionException e) {
            e.printStackTrace();
        }
        instance.freeze();
    }

    public static HNews getInstance() {
        return instance;
    }
}
