package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances;

import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.*;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.*;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.TextProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.URIProperty;

public class HProduct extends Microformat {
    final private static HProduct instance = new HProduct("hproduct", true);
    private static MFProperty url, relproduct;

    /**
     * the name should be equal to the header of microformat (e. g. "vcard")
     *
     * @param name
     */
    protected HProduct(@NotNull final String name, final boolean root) {
        super(name, root);
    }

    static {
        try {
            instance.addProperty(new MFPropertyPlural("category", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("photo", URIProperty.getInstance(), TextProperty.getInstance()));
            instance.addProperty(
                    url = new MFPropertySingular("url", URIProperty.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("brand", TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("fn", TextProperty.getInstance()));
            instance.addProperty(
                    new MFPropertyPlural("identifier", Identifier.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("price", TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("description", TextProperty.getInstance()));
            //review - not implemented
            //listing - not implemented
            instance.addProperty(relproduct = new MFPropertyRel("product"));
        } catch (InvalidActionException e) {
            e.printStackTrace();
        }
        instance.freeze();
    }

    public static HProduct getInstance() {
        return instance;
    }

    @Override
    public boolean postProcess(@NotNull final MicroformatData data, @NotNull final String content, final Node node) throws EmptyMFException, MFExceptions, InvalidActionException {
        if (data.isEmpty()) {
            throw new EmptyMFException(getName());
        }
        final MFExceptions ex = new MFExceptions(getName());
        if (data.isEmpty("category")) {
            ex.put(new PropertyNotDefinedMFException("category", false,data.getLocation()),"hProduct_condition");
        }
        if (data.isEmpty("brand")) {
            ex.put(new PropertyNotDefinedMFException("brand", false,data.getLocation()),"hProduct_condition");
        }
        if (data.isEmpty("fn")) {
            ex.put(new PropertyNotDefinedMFException("fn",data.getLocation()),"hProduct_condition");
        }
        if (data.isEmpty(url.getName()) && !data.isEmpty(relproduct.getName())) {
            try {
                data.addData(url, data.getDataAsList(relproduct.getName()).get(0));
                data.remove(relproduct.getName());
            } catch (InvalidDataMFException e) {
                e.printStackTrace();  //cannot be
            }
        }
        if (!ex.isEmpty()) {
            throw ex;
        }
        return false;
    }
}
