package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertyConcatenated;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertyPlural;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.Microformat;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.TextProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.URIProperty;

public class HResume extends Microformat {
    final private static HResume instance = new HResume("hresume", true);

    /**
     * the name should be equal to the header of microformat (e. g. "vcard")
     *
     * @param name
     */
    protected HResume(@NotNull final String name, final boolean root) {
        super(name, root);
    }

    static {
        try {
            instance.addProperty(new MFPropertyConcatenated("summary", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("contact", HCard.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("education", HResumeEvent.getInstance()));
            instance.addProperty(new MFPropertyPlural("experience", HResumeEvent.getInstance()));
            instance.addProperty(new MFPropertyPlural("skill", URIProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("affiliation", ExperienceHCard.getInstance()));
            instance.addProperty(new MFPropertyPlural("publications", TextProperty.getInstance()));
        } catch (InvalidActionException e) {
            e.printStackTrace();
        }
        instance.freeze();
    }

    public static HResume getInstance() {
        return instance;
    }
}
