package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances;

import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.*;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.*;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.DatetimeProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.TextProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.URIProperty;

public class HReview extends Microformat {
    final private static HReview instance = new HReview("hreview", true);
    private static MFProperty permalink, relself;

    /**
     * the name should be equal to the header of microformat (e. g. "vcard")
     *
     * @param name
     */
    protected HReview(@NotNull final String name, final boolean root) {
        super(name, root);
    }

    static {
        try {
            instance.addProperty(new MFPropertySingular("version", TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("type", TextProperty.getInstance()));
            instance.addProperty(permalink =
                    new MFPropertySingular("permalink", URIProperty.getInstance(), TextProperty.getInstance()));
            instance.addProperty(
                    new MFPropertySingular("mobile-url", URIProperty.getInstance(), TextProperty.getInstance()));
            instance.addProperty(
                    new MFPropertyPlural("item", HMedia.getInstance(), HProduct.getInstance(), HCard.getInstance(),
                            HCalendarEvent.getInstance(), ItemForHReview.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("photo", URIProperty.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("rating", Rating.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("owning-time", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("description", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("pro", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("contra", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("summary", TextProperty.getInstance()));
            instance.addProperty(
                    new MFPropertySingular("dtreviewed", DatetimeProperty.getInstance(), TextProperty.getInstance()));
            instance.addProperty(
                    new MFPropertySingular("dtvisited", DatetimeProperty.getInstance(), TextProperty.getInstance()));
            instance.addProperty(
                    new MFPropertyPlural("reviewsurl", URIProperty.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("reviewer", HCard.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertyRel("bookmark"));
            instance.addProperty(relself = new MFPropertyRel("self"));
            instance.addProperty(new MFPropertyRel("license"));
            instance.addProperty(new MFPropertyPlural("tag", HReviewTag.getInstance()));
        } catch (InvalidActionException e) {
            e.printStackTrace();
        }
        instance.freeze();
    }

    public static HReview getInstance() {
        return instance;
    }

    @Override
    public boolean postProcess(@NotNull final MicroformatData data, @NotNull final String content, final Node node) throws EmptyMFException, MFExceptions, InvalidActionException {
        if (data.isEmpty()) {
            throw new EmptyMFException(getName());
        }
        final MFExceptions ex = new MFExceptions(getName());
        Microformat itemType = null;
        if (data.isEmpty("item")) {
            //check required
            ex.put(new PropertyNotDefinedMFException("item"));
        } else {
            final MFAnyData item = data.getFirstOrNull("item");
            if (item instanceof MicroformatData) {
                itemType = ((MicroformatData) item).getSpec();
                if (item.getSpec() == HCard.getInstance()) {
                    if (!HCard.getInstance().isOrganization((MicroformatData) item)) {
                        ex.put(new NotOrgReviewMFException("",false, data.getLocation()));
                    } else if (((MicroformatData) item).getFirstOrNull("permalink") == null &&
                            ((MicroformatData) item).getFirstOrNull("url") == null) {
                        ex.put(new PropertyNotDefinedMFException("item.permalink | item.url", false, data.getLocation()));
                    }
                }
            }
        }
        if (data.isEmpty("description") && data.isEmpty("pro") && data.isEmpty("contra")) {
            //check required
            ex.put(new PropertyNotDefinedMFException("description | pro | contra", false, data.getLocation()),"hReview_condition");
        }
        if (data.isEmpty("dtreviewed")) {
            //check required
            ex.put(new PropertyNotDefinedMFException("dtreviewed", false, data.getLocation()),"hReview_condition");
        }
        if (data.isEmpty(permalink.getName())) {
            //check required
            ex.put(new PropertyNotDefinedMFException("permalink", false, data.getLocation()),"hReview_condition");
        }
        if (data.isEmpty("reviewer")) {
            //check required
            ex.put(new PropertyNotDefinedMFException("reviewer", false, data.getLocation()),"hReview_condition");
        } else {
            final MFAnyData reviewer = data.getFirstOrNull("reviewer");
            if (reviewer instanceof MicroformatData) {
                if (reviewer.getSpec() == HCard.getInstance() && itemType == HCard.getInstance()) {
                    if (((MicroformatData) reviewer).getFirstOrNull("permalink") == null &&
                            ((MicroformatData) reviewer).getFirstOrNull("url") == null) {
                        ex.put(new PropertyNotDefinedMFException("reviewer.permalink | reviewer.url", false, data.getLocation()));
                    }
                }
            }
        }
        if (data.isEmpty("type")) {
            //check required
            ex.put(new PropertyNotDefinedMFException("type", false, data.getLocation()),"hReview_condition");
        }
        if (!ex.isEmpty()) {
            throw ex;
        }
        return false;
    }
}
