package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances;

import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.EmptyMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFExceptions;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.PropertyNotDefinedMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertyPlural;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertySingular;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.Microformat;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.TextProperty;

public class HReviewAggregate extends Microformat {
    final private static HReviewAggregate instance = new HReviewAggregate("hreview-aggregate", true);

    /**
     * the name should be equal to the header of microformat (e. g. "vcard")
     *
     * @param name
     */
    protected HReviewAggregate(@NotNull final String name, final boolean root) {
        super(name, root);
    }

    static {
        try {
            instance.addProperty(new MFPropertyPlural("summary", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("item", HProduct.getInstance(), HCard.getInstance(),
                    HCalendarEvent.getInstance(), ItemForHReview.getInstance(), TextProperty.getInstance()));
            instance.addProperty(
                    new MFPropertySingular("rating", AggregateRating.getInstance(), TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("count", TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("votes", TextProperty.getInstance()));
        } catch (InvalidActionException e) {
            e.printStackTrace();
        }
        instance.freeze();
    }

    public static HReviewAggregate getInstance() {
        return instance;
    }

    @Override
    public boolean postProcess(@NotNull final MicroformatData data, @NotNull final String content, final Node node) throws EmptyMFException, InvalidActionException, MFExceptions {
        if (data.isEmpty()) {
            throw new EmptyMFException(getName(),data.getLocation());
        }
        final MFExceptions ex = new MFExceptions(getName());
        if (data.isEmpty("count") && data.isEmpty("votes")) {
            ex.put(new PropertyNotDefinedMFException("votes | count",data.getLocation()));
        }
        if (!ex.isEmpty()) {
            throw ex;
        }
        return false;
    }
}
