package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances;

import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.EmptyMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.MFExceptions;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertySingular;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertyValue;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.Microformat;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.TextProperty;

public class Ingredient extends Microformat {
    final private static Ingredient instance = new Ingredient("ingredient", false);
    private static MFProperty value;

    /**
     * the name should be equal to the header of microformat (e. g. "vcard")
     *
     * @param name
     */
    protected Ingredient(@NotNull final String name, final boolean root) {
        super(name, root);
    }

    static {
        try {
            instance.addProperty(new MFPropertySingular("name", TextProperty.getInstance()));
            instance.addProperty(new MFPropertySingular("type", TextProperty.getInstance()));
            instance.addProperty(value = new MFPropertyValue());
            instance.addProperty(new MFPropertySingular("amount", TextProperty.getInstance()));
        } catch (InvalidActionException e) {
            throw new RuntimeException(e);
        }
        instance.freeze();
    }

    public static Ingredient getInstance() {
        return instance;
    }

    @Override
    public boolean postProcess(@NotNull final MicroformatData data, @NotNull final String content, final Node node) throws InvalidActionException, EmptyMFException, MFExceptions {
        MFExceptions exs = new MFExceptions(instance.getName());
        boolean modifed = false;
        if (data.isEmpty()) {
            try {
                modifed |= data.postProcess(getProperty("amount"), content, node);
            } catch (MFException e) {
                exs.put(e);
            }
        }
        if (!exs.isEmpty()) {
            throw exs;
        }
        return modifed;
    }
}
