package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.instances;

import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MicroformatData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types.TextData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.EmptyMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidActionException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.exceptions.InvalidDataMFException;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFProperty;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFPropertyPlural;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.Microformat;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types.TextProperty;

public class N extends Microformat {
    final private static N instance = new N("n", false);
    private static MFProperty fn, gn;

    /**
     * the name should be equal to the header of microformat (e. g. "vcard")
     *
     * @param name
     */
    protected N(@NotNull final String name, final boolean root) {
        super(name, root);
    }

    static {
        try {
            instance.addProperty(fn = new MFPropertyPlural("family-name", TextProperty.getInstance()));
            instance.addProperty(gn = new MFPropertyPlural("given-name", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("additional-name", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("honorific-prefix", TextProperty.getInstance()));
            instance.addProperty(new MFPropertyPlural("honorific-suffix", TextProperty.getInstance()));
        } catch (InvalidActionException e) {
            e.printStackTrace();
        }
        instance.freeze();
    }

    public static N getInstance() {
        return instance;
    }

    @Override
    public boolean postProcess(@NotNull final MicroformatData data, @NotNull final String content, final Node node) throws EmptyMFException, InvalidActionException {
        if (data.isEmpty()) {
            final String[] parts = content.trim().split("\\s+");
            if (parts.length == 2) {
                if (parts[0].endsWith(",")) {
                    try {
                        addData(data, fn, new TextData(parts[0].substring(0, parts[0].length() - 1)));
                        addData(data, gn, new TextData(parts[1]));
                    } catch (InvalidDataMFException e) {
                        throw new EmptyMFException(getName(), data.getLocation());
                    }
                } else {
                    try {
                        addData(data, gn, new TextData(parts[0]));
                        addData(data, fn, new TextData(parts[1]));
                    } catch (InvalidDataMFException e) {
                        throw new EmptyMFException(getName(), data.getLocation());
                    }
                }
            } else {
                throw new EmptyMFException(getName(), data.getLocation());
            }
            return true;
        }
        return false;
    }
}
