package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types.DatetimeData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFType;

public class DatetimeProperty implements MFType {

    private static DatetimeProperty instance;

    private DatetimeProperty() {
    }

    public DatetimeData createData() {
        return new DatetimeData();
    }

    public String toShortString(@NotNull final MFAnyData data) {
        return data.toString();
    }

    @Override
    public String toDebugString(@NotNull final MFAnyData data, @NotNull final String indent) {
        return data.toString();
    }

    public static DatetimeProperty getInstance() {
        if (instance == null) {
            instance = new DatetimeProperty();
        }
        return instance;
    }
}
