package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types.FlagData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFType;

public class FlagProperty implements MFType {

    private static FlagProperty instance;

    private FlagProperty() {
    }

    public FlagData createData() {
        return new FlagData();
    }

    public String toShortString(@NotNull final MFAnyData data) {
        return data.toString();
    }

    @Override
    public String toDebugString(@NotNull final MFAnyData data, @NotNull final String indent) {
        return data.toString();
    }

    public static FlagProperty getInstance() {
        if (instance == null) {
            instance = new FlagProperty();
        }
        return instance;
    }
}
