package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types.HTMLData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFType;

public class HTMLProperty implements MFType {

    private static HTMLProperty instance;

    private HTMLProperty() {
    }

    public HTMLData createData() {
        return new HTMLData();
    }

    public String toShortString(@NotNull final MFAnyData data) {
        return data.toString();
    }

    @Override
    public String toDebugString(@NotNull final MFAnyData data, @NotNull final String indent) {
        return data.toString();
    }

    public static HTMLProperty getInstance() {
        if (instance == null) {
            instance = new HTMLProperty();
        }
        return instance;
    }
}
