package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types.TextData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFType;

public class TextProperty implements MFType {

    private static TextProperty instance;

    private TextProperty() {
    }

    public TextData createData() {
        return new TextData();
    }

    public String toShortString(@NotNull final MFAnyData data) {
        return data.toString();
    }

    @Override
    public String toDebugString(@NotNull final MFAnyData data, @NotNull final String indent) {
        return data.toString();
    }

    public static TextProperty getInstance() {
        if (instance == null) {
            instance = new TextProperty();
        }
        return instance;
    }
}
