package ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.property_types;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.MFAnyData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.data.property_types.URIData;
import ru.yandex.webmaster3.core.semantic.semantic_document_parser.microformats.spec.MFType;

public class URIProperty implements MFType {

    private static URIProperty instance;

    private URIProperty() {
    }

    public URIData createData() {
        return new URIData();
    }

    public String toShortString(@NotNull final MFAnyData data) {
        return data.toString();
    }

    @Override
    public String toDebugString(@NotNull final MFAnyData data, @NotNull final String indent) {
        return data.toString();
    }

    public static URIProperty getInstance() {
        if (instance == null) {
            instance = new URIProperty();
        }
        return instance;
    }
}
